// Autor: Frane Kurtovic

#include <iostream>

using namespace std;

const int MXP = 1001;
const int MXK = 1001;
const int INF = MXP + 1;
char parking[MXP];
int dp[MXP][MXK];
int cost[MXP][MXP]; // cost[i][j] = broj auta u intervalu [i, i+j>

int main() {
  int p, k, l;
  cin >> p >> k >> l;
  cin >> parking;

  for (int i = p - 1; i >= 0; i--) {
    if (parking[i] == '#') cost[i][1] = 1;
    else cost[i][1] = 0;
  }
  for (int j = 2; j <= l; j++) {
    for (int i = p; i > p - j; i--) {
      cost[i][j] = INF;
    }
    for (int i = p - j; i >= 0; i--) {
      cost[i][j] = cost[i + 1][j - 1];
      if (parking[i] == '#') cost[i][j]++;
    }
  }
  // dp[i][n] oznacava koliko je najmanje auta potrebno maknuti na dijelu
  // parking od i-tog indeksa do kraja, a ako imamo n kamiona za sparkirati
  dp[p][0] = 0;
  for (int n = 1; n <= k; n++) {
    dp[p][n] = INF;
  }
  for (int i = p - 1; i >= 0; i--) {
    dp[i][0] = 0;
    for (int n = 1; n <= k; n++) {
      dp[i][n] = dp[i + 1][n];
      dp[i][n] = min(dp[i][n], dp[i + l][n - 1] + cost[i][l]);
    }
  }
  cout << dp[0][k] << endl;
  return 0;
}
